<?php
session_start();
include '../../db_setup.php';
date_default_timezone_set('Asia/Jakarta');

if(!isset($_SESSION['nik'])) exit('Belum login');

$nama = $_SESSION['nama'];
$tanggal = date('Y-m-d');
$jam = date('H:i:s');

$type = $_POST['type'] ?? '';
$dataURL = $_POST['photo'] ?? '';
$lokasi = $_POST['lokasi'] ?? 'unknown';

// Validasi lokasi
if($lokasi!=='unknown'){
    $parts = explode(',', $lokasi);
    if(count($parts)!==2 || !is_numeric($parts[0]) || !is_numeric($parts[1])) {
        $lokasi = 'unknown';
    }
}

if(!$dataURL) exit('Tidak ada data foto');

// ====== Pastikan Base64 benar ======
if(strpos($dataURL, 'base64,') !== false){
    $data = explode(',', $dataURL)[1];
} else {
    $data = $dataURL;
}

$decoded = base64_decode($data);
if(!$decoded) exit('Gagal decode foto.');

// ====== Buat gambar dari base64 ======
$img = @imagecreatefromstring($decoded);
if(!$img) exit('Format gambar tidak dikenali atau rusak.');

// ====== Perbaiki orientasi EXIF (khusus JPEG) ======
$tempFile = tempnam(sys_get_temp_dir(), 'photo_');
file_put_contents($tempFile, $decoded);
if(function_exists('exif_read_data')){
    $exif = @exif_read_data($tempFile);
    if(!empty($exif['Orientation'])){
        switch($exif['Orientation']){
            case 3: $img = imagerotate($img, 180, 0); break;
            case 6: $img = imagerotate($img, -90, 0); break;
            case 8: $img = imagerotate($img, 90, 0); break;
        }
    }
}
unlink($tempFile);

// ====== Resize gambar ======
$maxWidth = 400;
$maxHeight = 400;
$width = imagesx($img);
$height = imagesy($img);
$ratio = min($maxWidth / $width, $maxHeight / $height, 1);
$newWidth = (int)($width * $ratio);
$newHeight = (int)($height * $ratio);

$resized = imagecreatetruecolor($newWidth, $newHeight);
imagecopyresampled($resized, $img, 0, 0, 0, 0, $newWidth, $newHeight, $width, $height);

// ====== Simpan file ======
$folder = 'uploads/';
if(!is_dir($folder)) mkdir($folder, 0755, true);

$filename = $nama . '_' . $type . '_' . $tanggal . '_' . time() . '.jpg';
$filePath = $folder . $filename;

imagejpeg($resized, $filePath, 80);
imagedestroy($img);
imagedestroy($resized);

// ====== Simpan ke database ======
$cek = $conn->prepare("SELECT * FROM absensi WHERE tanggal=? AND nama=?");
$cek->bind_param("ss", $tanggal, $nama);
$cek->execute();
$res = $cek->get_result();
$absen = $res->fetch_assoc();

// Absen Masuk
if($type === 'masuk'){
    if(!$absen){
        $stmt = $conn->prepare("INSERT INTO absensi (nama,tanggal,jam_masuk,foto_masuk,scan_masuk,lokasi_masuk) VALUES (?,?,?,?,?,?)");
        $stmt->bind_param("ssssss", $nama, $tanggal, $jam, $filename, $jam, $lokasi);
        $stmt->execute();
        echo "✅ Absen masuk berhasil";
    } else {
        echo "⚠️ Anda sudah absen masuk hari ini";
    }

// Absen Pulang
}elseif($type === 'pulang'){
    if($absen){
        if(empty($absen['jam_pulang'])){
            $stmt = $conn->prepare("UPDATE absensi SET jam_pulang=?,foto_pulang=?,scan_pulang=?,lokasi_pulang=? WHERE id=?");
            $stmt->bind_param("ssssi", $jam, $filename, $jam, $lokasi, $absen['id']);
            $stmt->execute();
            echo "✅ Absen pulang berhasil";
        } else {
            echo "⚠️ Anda sudah absen pulang hari ini";
        }
    } else {
        $stmt = $conn->prepare("INSERT INTO absensi (nama,tanggal,jam_pulang,foto_pulang,scan_pulang,lokasi_pulang) VALUES (?,?,?,?,?,?)");
        $stmt->bind_param("ssssss", $nama, $tanggal, $jam, $filename, $jam, $lokasi);
        $stmt->execute();
        echo "✅ Absen pulang langsung berhasil";
    }
}
?>
