<?php
session_start();
include '../../db_setup.php';

// pastikan timezone WIB (GMT+7)
date_default_timezone_set('Asia/Jakarta');

$error = "";

// ===================
// Proses Login
// ===================
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['login'])) {
    $nik = trim($_POST['nik']);

    // cek data karyawan
    $stmt = $conn->prepare("SELECT * FROM karyawan WHERE nik = ?");
    $stmt->bind_param("s", $nik);
    $stmt->execute();
    $result = $stmt->get_result();
    $karyawan = $result->fetch_assoc();

    if ($karyawan && $nik === $karyawan['nik']) {
        $_SESSION['nik']  = $karyawan['nik'];
        $_SESSION['nama'] = $karyawan['nama'];
        header("Location: login.php"); // reload ke halaman absen
        exit;
    } else {
        $error = "NIK tidak ditemukan.";
    }
}

// ===================
// Form Login jika belum login
// ===================
if (!isset($_SESSION['nik'])) {
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Login Absen</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
  <style>
    body {
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      background: linear-gradient(135deg, #4e54c8, #8f94fb);
    }
    .card {
      border-radius: 20px;
      backdrop-filter: blur(10px);
      background: rgba(255, 255, 255, 0.9);
    }
  </style>
</head>
<body>
  <div class="card shadow p-4" style="max-width: 400px; width: 100%;">
    <h3 class="text-center mb-3">Login Absen</h3>
    <?php if($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>
    <form method="post">
      <div class="mb-3">
        <label for="nik" class="form-label">NIK</label>
        <input type="text" class="form-control" name="nik" id="nik" required autofocus>
      </div>
      <button type="submit" name="login" class="btn btn-primary w-100">Login</button>
    </form>
  </div>
</body>
</html>
<?php
    exit;
}

// ===================
// Jika sudah login → menu absen
// ===================
$nik     = $_SESSION['nik'];
$nama    = $_SESSION['nama'];
$tanggal = date("Y-m-d");
$jam     = date("H:i:s");

$msg = "";

// cek apakah sudah ada absen hari ini
$cek = $conn->prepare("SELECT * FROM absensi WHERE tanggal = ? AND nama = ?");
$cek->bind_param("ss", $tanggal, $nama);
$cek->execute();
$res = $cek->get_result();
$absen = $res->fetch_assoc();

// ===================
// Aksi Absen Masuk
// ===================
if (isset($_POST['absen_masuk'])) {
    if (!$absen) {
        $stmt = $conn->prepare("INSERT INTO absensi (nama, tanggal, jam_masuk, scan_masuk) VALUES (?, ?, ?, ?)");
        $scan = $jam;
        $stmt->bind_param("ssss", $nama, $tanggal, $jam, $scan);
        $stmt->execute();
        $msg = "✅ Absen masuk berhasil jam $jam";
    } else {
        $msg = "⚠️ Anda sudah punya data absen hari ini.";
    }
}

// ===================
// Aksi Absen Pulang
// ===================
if (isset($_POST['absen_pulang'])) {
    if ($absen) {
        if (empty($absen['jam_pulang'])) {
            // update di record yang sama
            $stmt = $conn->prepare("UPDATE absensi SET jam_pulang=?, scan_pulang=? WHERE id=?");
            $scan = $jam;
            $stmt->bind_param("ssi", $jam, $scan, $absen['id']);
            $stmt->execute();
            $msg = "✅ Absen pulang berhasil jam $jam";
        } else {
            $msg = "⚠️ Anda sudah absen pulang hari ini.";
        }
    } else {
        // kalau belum ada record masuk → buat langsung record pulang
        $stmt = $conn->prepare("INSERT INTO absensi (nama, tanggal, jam_pulang, scan_pulang) VALUES (?, ?, ?, ?)");
        $scan = $jam;
        $stmt->bind_param("ssss", $nama, $tanggal, $jam, $scan);
        $stmt->execute();
        $msg = "⚠️ Anda langsung absen pulang jam $jam (tanpa absen masuk).";
    }
}

// ===================
// Hitung sisa cuti
// ===================
$id_karyawan = null;
$stmt = $conn->prepare("SELECT id_karyawan FROM karyawan WHERE nik = ?");
$stmt->bind_param("s", $nik);
$stmt->execute();
$res = $stmt->get_result();
if ($row = $res->fetch_assoc()) {
    $id_karyawan = $row['id_karyawan'];
}

$tahun = date("Y");
$totalCutiSetahun = 12;
$jumlahCuti = 0;
$sisaCuti   = $totalCutiSetahun;

if ($id_karyawan) {
    $q = $conn->prepare("SELECT COUNT(*) as total FROM cuti_karyawan 
                         WHERE id_karyawan = ? AND YEAR(tanggal_awal) = ?");
    $q->bind_param("ii", $id_karyawan, $tahun);
    $q->execute();
    $result = $q->get_result()->fetch_assoc();
    $jumlahCuti = $result['total'];
    $sisaCuti   = $totalCutiSetahun - $jumlahCuti;
}

// ===================
// Hitung Ijin Bulanan
// ===================
$ijinList = [];
$totalIjinBulan = 0;

if ($id_karyawan) {
    $bulan = date("m");
    $tahun = date("Y");

    $q = $conn->prepare("SELECT * FROM ijin_karyawan 
                         WHERE id_karyawan = ? 
                         AND MONTH(tanggal_awal) = ? 
                         AND YEAR(tanggal_awal) = ?
                         ORDER BY tanggal_awal DESC");
    $q->bind_param("iii", $id_karyawan, $bulan, $tahun);
    $q->execute();
    $res = $q->get_result();

    while ($row = $res->fetch_assoc()) {
        $ijinList[] = $row;
    }
    $totalIjinBulan = count($ijinList);
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Absen Harian</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
  <style>
    body {
      min-height: 100vh;
      display: flex;
      justify-content: center;
      align-items: center;
      background: linear-gradient(135deg, #8E2DE2, #4A00E0);
      padding: 15px;
    }
    .card {
      width: 100%;
      max-width: 500px;
      border-radius: 20px;
      backdrop-filter: blur(10px);
      background: rgba(255, 255, 255, 0.95);
    }
    .btn {
      flex: 1;
    }
  </style>
</head>
<body>
<div class="container my-4 d-flex flex-column align-items-center">
  
  <!-- Card Absensi -->
  <div class="card shadow p-4 mb-4">
    <h3 class="mb-3 text-center">Halo, <?= htmlspecialchars($nama) ?> (<?= htmlspecialchars($nik) ?>)</h3>
    <p class="text-center">Tanggal: <?= $tanggal ?> | Waktu sekarang: <?= $jam ?> WIB</p>

    <?php if(!empty($msg)): ?>
      <div class="alert alert-info text-center"><?= $msg ?></div>
    <?php endif; ?>

    <form method="post" class="d-flex flex-column flex-sm-row gap-2">
      <button type="submit" name="absen_masuk" class="btn btn-success">Absen Masuk</button>
      <button type="submit" name="absen_pulang" class="btn btn-danger">Absen Pulang</button>
      <a href="logout.php" class="btn btn-secondary">Logout</a>
    </form>
  </div>

  <!-- Card Sisa Cuti -->
  <div class="card shadow p-3 mb-4">
    <h5 class="text-center">📌 Informasi Cuti</h5>
    <p class="text-center mb-0">
      Anda sudah cuti <strong><?= $jumlahCuti ?></strong> Kali,
      sisa cuti anda tinggal <strong><?= $sisaCuti ?></strong>.
    </p>
  </div>

  <!-- Card Ijin Bulanan -->
  <div class="card shadow p-3 mb-4">
    <h5 class="text-center">📅 Ijin Bulan <?= date("F Y") ?></h5>
    <p class="text-center mb-2">
      Total ijin bulan ini: <strong><?= $totalIjinBulan ?></strong>
    </p>
    <?php if ($totalIjinBulan > 0): ?>
      <ul class="list-group list-group-flush">
        <?php foreach ($ijinList as $ijin): ?>
          <li class="list-group-item">
            <strong><?= htmlspecialchars($ijin['jenis_ijin']) ?></strong> 
            (<?= date("d-m-Y", strtotime($ijin['tanggal_awal'])) ?> 
            <?= $ijin['tanggal_awal'] != $ijin['tanggal_akhir'] ? ' s/d '.date("d-m-Y", strtotime($ijin['tanggal_akhir'])) : '' ?>)
            <br>
            <small class="text-muted"><?= htmlspecialchars($ijin['keterangan'] ?? '-') ?></small>
          </li>
        <?php endforeach; ?>
      </ul>
    <?php else: ?>
      <p class="text-center text-muted">Tidak ada ijin bulan ini.</p>
    <?php endif; ?>
  </div>

  <!-- Card Ijin Harian -->
  <div class="card shadow p-4">
    <form method="post" class="d-flex flex-column flex-sm-row gap-2">
      <a href="/dasi/ijin.php" class="btn btn-warning w-100">IJIN HARIAN</a>
    </form>
  </div>

</div>
</body>
</html>
