<!doctype html>
<html>
<head><meta charset="utf-8"><title>Geo Test</title></head>
<body>
<button id="btn">Ambil Lokasi</button>
<pre id="out"></pre>

<script>
document.getElementById('btn').addEventListener('click', function() {
    if (!navigator.geolocation) {
        document.getElementById('out').textContent = 'Geolocation tidak tersedia';
        return;
    }

    navigator.geolocation.getCurrentPosition(function(pos) {
        const lat = pos.coords.latitude;
        const lon = pos.coords.longitude;
        const acc = pos.coords.accuracy;
        document.getElementById('out').textContent = `lat=${lat}\nlon=${lon}\nacc=${acc}m`;

        // contoh kirim ke server (ubah endpoint sesuai backend Anda)
        fetch('/save_location', {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify({lat: lat, lon: lon, acc: acc})
        }).then(r => {
            console.log('server response', r.status);
        }).catch(err => console.error(err));

    }, function(err) {
        document.getElementById('out').textContent = 'Error: ' + err.message;
    }, {enableHighAccuracy: true, timeout: 10000, maximumAge: 0});
});
</script>
</body>
</html>
